/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: FieldEditor.cpp 2492 2018-03-21 06:22:15Z stephane $
 */

#include "GPC.hpp"


FieldEditor::FieldEditor(void)
{
	setBorder(BorderSize<int>(3));
	setMultiLine					(true, true	);
	setCaretVisible					(true		);
	setEscapeAndReturnKeysConsumed	(false		);
	setReturnKeyStartsNewLine		(false		);
	setScrollbarsShown				(false		);
	setTabKeyUsedAsCharacter		(false		);
	setSize							(300, 50	);

	addListener(this);

	return;
}


FieldEditor::~FieldEditor(void)
{
	return;
}


void FieldEditor::textEditorEscapeKeyPressed(TextEditor &editor)
{
	// attempt to exit from the calloutbox
	Component *c = findParentComponentOfClass<Component>();
	if (c)
	{
		// send back a zero to indicate we want to cancel the change
		c->exitModalState(0);
	}

	return;
}


void FieldEditor::textEditorReturnKeyPressed(TextEditor &editor)
{
	// attempt to exit from the calloutbox
	Component *c = findParentComponentOfClass<Component>();
	if (c)
	{
		// send back a one to indicate we want to change the text
		c->exitModalState(1);
	}

	return;
}
