/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: FieldEditor.hpp 2492 2018-03-21 06:22:15Z stephane $
 */

#pragma once


#include "GPC.hpp"


/** Tiny helper class to show a text editor.  The editor assumes that the
 * parent is showing it modally, and will call @ref exitModalState() if it
 * detects the user has pressed ENTER or ESCAPE.
 */
class FieldEditor : public TextEditor, public TextEditor::Listener
{
	public:

		/// Constructor.
		FieldEditor(void);

		/// Destructor.
		virtual ~FieldEditor(void);

		/// Inherited from TextEditor::Listener.
		virtual void textEditorEscapeKeyPressed(TextEditor &editor);

		/// Inherited from TextEditor::Listener.
		virtual void textEditorReturnKeyPressed(TextEditor &editor);
};
