/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: SessionComponent.hpp 2492 2018-03-21 06:22:15Z stephane $
 */

#pragma once


#include "GPC.hpp"


class SessionComponent : public Component, public Button::Listener, public TextEditor::Listener, public TableListBoxModel
{
	public:

		SessionComponent(const std::string &uuid);

		virtual ~SessionComponent(void);

		/// Inherited from Component.  Used to re-layout the widgets.
		virtual void resized(void);

		/// Inherited from ButtonListener.
		virtual void buttonClicked(Button *button);

		/// Inherited from TableListBoxModel.
		virtual int getNumRows(void);

		/// Inherited from TableListBoxModel.
		virtual void paintCell(Graphics &g, int rowNumber, int columnId, int width, int height, bool rowIsSelected);

		/// Inherited from TableListBoxModel.
		virtual void paintRowBackground(Graphics &g, int rowNumber, int width, int height, bool rowIsSelected);

		/// Inherited from TableListBoxModel.
		virtual void selectedRowsChanged(int lastRowSelected);

		/// Inherited from TextEditor::Listener.
		virtual void textEditorTextChanged(TextEditor &editor);

		/// Inherited from TableListBoxModel.
		virtual void returnKeyPressed(int row);

		/// Inherited from TableListBoxModel.
		virtual void cellDoubleClicked(int row, int column, const MouseEvent &event);

		/// Show a CallOutBox with an entryfield so the user can edit the image description.
		void edit_description_field(const int row);

		bool transfer_print_session(void);

		SessionRecord &session_record;

		PrintJob print_job;

		TextEditor description;

		DrawableButton replace_image_button;
		DrawableButton reverse_image_button;
		DrawableButton open_folder_button;
		DrawableButton transfer_button;

		TableListBox table;

		std::unique_ptr<SessionComponentLoader> session_component_loader;

		std::unique_ptr<SessionComponentTransfer> transfer_in_progress;
};
