/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: SummaryComponent.hpp 2513 2018-04-07 07:21:06Z stephane $
 */

#pragma once


#include "GPC.hpp"


class SummaryComponent : public Component, public TableListBoxModel, public Button::Listener, public Timer
{
	public:

		SummaryComponent(void);

		virtual ~SummaryComponent(void);

		/// Inherited from Component.  Used to re-layout the widgets.
		virtual void resized(void);

		/// Inherited from ButtonListener.
		virtual void buttonClicked(Button *button);

		/// Inherited from TableListBoxModel.
		virtual int getNumRows(void);

		/// Inherited from TableListBoxModel.
		virtual void paintCell(Graphics &g, int rowNumber, int columnId, int width, int height, bool rowIsSelected);

		/// Inherited from TableListBoxModel.
		virtual void paintRowBackground(Graphics &g, int rowNumber, int width, int height, bool rowIsSelected);

		/// Inherited from TableListBoxModel.
		virtual void sortOrderChanged(int newSortColumnId, bool isForwards);

		/// Inherited from TableListBoxModel.
		virtual void selectedRowsChanged(int lastRowSelected);

		/// Inherited from TableListBoxModel.
		virtual void cellDoubleClicked(int rowNumber, int columnId, const MouseEvent &mouseEvent);

		/// Inherited from TableListBoxModel.
		virtual void returnKeyPressed(int rowNumber);

		/// Called from @ref cellDoubleClicked() and @ref returnKeyPressed() to open a specific session.
		void openSession(const int rowNumber);

		/// Inherited from Timer.  Used to filter the records and update the status.
		virtual void timerCallback(void);

		///
		virtual void delete_hidden_session_windows(void);

		void apply_log_filtering(const bool table_was_sorted=false);

		/// Re-populate the @ref uuid_index vector.
		void rebuild_index(void);

		/** Vector of UUIDs which determines how the rows are shown in the
		 * table.  First UUID corresponds to the first row, etc.
		 */
		VStr uuid_index;

		SStr uuids_of_selected_rows;
		void remember_selected_rows(void);
		void restore_selected_rows(void);

		/// Vector of strings to store the most recent text filters.
		VStr			filters;

		Label			summary_label;
		TextEditor		search_bar;
		TextButton		import_button;
		TextButton		clone_button;
		TextButton		refresh_button;
		TableListBox	table;

		/// Stores all records from the database.  This vector is not sorted nor filtered beyond what the database view provides by default.  @see @ref table_records.
//		VRecords all_records;

		/// Stores only the records shown to the user.  This vector has been sorted and filtered.  @see @ref all_records
//		VRecords table_records;

		/** Lock used when managing editor windows.  Editors are stored in a
		 * container which must not be modified by multiple threads at once.
		 * This lock ensures that things stay sane.
		 */
		CriticalSection critial_section_for_all_session_windows;

		/** std::map of all editor window pointers.  Make sure you lock
		 * @ref critial_section_for_all_session_windows before using the map.
		 */
		MUuidSessionWnd all_session_windows;
};
