# GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
# $Id: CM_source.cmake 2479 2018-03-13 09:41:49Z stephane $


# get rid of the directories and files automatically created by Introjucer since we're using our own CMake build files
FILE ( REMOVE_RECURSE Builds Source )

# build JUCE prior to enabling Wall Wextra Werror
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/JuceLibraryCode )
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/JuceLibraryCode/modules )
ADD_SUBDIRECTORY ( src-juce )

IF ( UNIX )
	ADD_DEFINITIONS ( "-Wall -Wextra -Werror -Wno-unused-parameter" )
ENDIF ()

INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-easybmp		)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-json			)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-misc			)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-img			)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-log			)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-cfg			)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-incjet			)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-session-record	)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-wnd-summary	)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-wnd-session	)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-gpc			)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-gpc			)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-ijb			)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-ijs			)
INCLUDE_DIRECTORIES ( BEFORE ${CMAKE_CURRENT_SOURCE_DIR}/src-printjob		)

ADD_SUBDIRECTORY ( src-easybmp			)
ADD_SUBDIRECTORY ( src-misc 			)
ADD_SUBDIRECTORY ( src-img				)
ADD_SUBDIRECTORY ( src-log				)
ADD_SUBDIRECTORY ( src-cfg				)
ADD_SUBDIRECTORY ( src-session-record	)
ADD_SUBDIRECTORY ( src-wnd-summary		)
ADD_SUBDIRECTORY ( src-wnd-session		)
ADD_SUBDIRECTORY ( src-incjet			)
ADD_SUBDIRECTORY ( src-ijb				)
ADD_SUBDIRECTORY ( src-ijs				)
ADD_SUBDIRECTORY ( src-printjob			)
ADD_SUBDIRECTORY ( src-gpc				)
ADD_SUBDIRECTORY ( other-ubuntu			)
ADD_SUBDIRECTORY ( other-win64			)
ADD_SUBDIRECTORY ( other-win32			)
ADD_SUBDIRECTORY ( doxygen				)
