/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: BinaryProtocolConnection.hpp 2490 2018-03-19 07:07:56Z stephane $
 */

#pragma once

#include "GPC.hpp"


class BinaryProtocolConnection final
{
	public:

		/// Constructor.
		BinaryProtocolConnection(const std::string ip, const int tcp);

		/// Destructor.
		~BinaryProtocolConnection(void);

		/// Connect to the IncJet device.
		BinaryProtocolConnection &connect(void);

		/// Initiate communications.
		BinaryProtocolConnection &initiate_communications(void);

		/// Upload a file.
		BinaryProtocolConnection &send_file(const bool is_ijs, const VBytes &file_contents);

		/// Send end-of-file.
		BinaryProtocolConnection &send_eof(void);

		/// Write the specified command and expect the IncJet device to reply with an ACK (0x09).
		BinaryProtocolConnection &write_and_expect_ack(const BinaryProtocol &bp);

		int port;
		std::string ip_address;
		std::string name;
		StreamingSocket sock;
};
