/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: IncJet.cpp 2465 2018-03-07 16:20:04Z stephane $
 */

#include "GPC.hpp"


IncJet::IncJet(void)
{
//	ip_address = "10.1.1.22";
	ip_address = cfg().get_str("print_controller_ip_address");

	return;
}


IncJet::~IncJet(void)
{
	return;
}


std::string IncJet::get(const std::string &partialUrl)
{
	std::string url = "http://" + ip_address;
	if (partialUrl.empty() || partialUrl[0] != '/')
	{
		url += "/";
	}
	url += partialUrl;

	std::string result = get_url(url);

	return result;
}


std::string IncJet::get(const IncJet::EPredefinedUrl &url)
{
	std::string partialUrl;
	switch (url)
	{
		case IncJet::EPredefinedUrl::kInvalid:				partialUrl = "/";						break;
		case IncJet::EPredefinedUrl::kFirmwareVersion:		partialUrl = "/fwversion.htm";			break;
		case IncJet::EPredefinedUrl::kSystemStateUpdate:	partialUrl = "/systemstateupdate.htm";	break;
	}

	const std::string output = get(partialUrl);

	/* Try to parse the value from within the result, for example:
	 *
	 *		&GetFWVersion=5182073&		-> 5182073
	 *		&SysState=0&				-> 0
	 */
	const std::regex rx( "^&[0-9a-zA-Z]+=(.+)&\\s*$" );
	std::smatch match;
	if ( std::regex_match(output, match, rx) )
	{
		const std::string value = match.str(1);
		return value;
	}

	return output;
}
