/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: SessionWnd.cpp 2474 2018-03-11 01:42:57Z stephane $
 */

#include "SessionWnd.hpp"
#include "src-img.hpp"
#include "GPC.hpp"


SessionWnd::SessionWnd(const std::string &uuid) :
	DocumentWindow(
		"GPC v"  + String(GPC_VERSION) + " - Print Control",
			Desktop::getInstance().getDefaultLookAndFeel().findColour(ResizableWindow::backgroundColourId),
			DocumentWindow::TitleBarButtons::allButtons),
	canvas(uuid)
{
	setContentNonOwned( &canvas, false );

	centreWithSize			( 640, 480		);
	setUsingNativeTitleBar	( true			);
	setResizable			( true, true	);
	setDropShadowEnabled	( true			);

	setName(canvas.session_record.field[SessionRecord::EField::kIjsFilename] + " - " + canvas.session_record.field[SessionRecord::EField::kPrinterName]);

	setIcon(GormanLogo());
	ComponentPeer *peer = getPeer();
	if (peer)
	{
		peer->setIcon(GormanLogo());
	}

	if (cfg().containsKey("SessionWnd"))
	{
		restoreWindowStateFromString( cfg().getValue("SessionWnd") );
	}

	setVisible(true);

	return;
}


SessionWnd::~SessionWnd(void)
{
	cfg().setValue("SessionWnd", getWindowStateAsString());

	return;
}


void SessionWnd::closeButtonPressed(void)
{
	/* Deleting ourself (as in "delete this") is a recipe for memory corruption
	 * and other strange bugs.  So we grab the garbage collection mutex, make
	 * ourself invisible, and then wait for SummaryComponent's timer to
	 * do the garbage collection for us.
	 */
	const ScopedLock lock(summaryWnd().canvas.critial_section_for_all_session_windows);
	setVisible(false);

	return;
}
