/* GPC (C) 2017-2018 Stephane Charette <stephanecharette@gmail.com>
 * $Id: SummaryWnd.cpp 2465 2018-03-07 16:20:04Z stephane $
 */

#include "GPC.hpp"


SummaryWnd::SummaryWnd(void) :
	DocumentWindow(
		"GPC v"  + String(GPC_VERSION) + " - Print Control",
		Desktop::getInstance().getDefaultLookAndFeel().findColour(ResizableWindow::backgroundColourId),
		DocumentWindow::TitleBarButtons::allButtons)
{
	setContentNonOwned( &canvas, false );

	centreWithSize			( 640, 480		);
	setUsingNativeTitleBar	( true			);
	setResizable			( true, true	);
	setDropShadowEnabled	( true			);

	setIcon(GormanLogo());
	ComponentPeer *peer = getPeer();
	if (peer)
	{
		peer->setIcon(GormanLogo());
	}

	if (cfg().containsKey("SummaryWnd"))
	{
		restoreWindowStateFromString( cfg().getValue("SummaryWnd") );
	}

	setVisible(true);

	return;
}


SummaryWnd::~SummaryWnd(void)
{
	cfg().setValue("SummaryWnd", getWindowStateAsString());

	return;
}


void SummaryWnd::closeButtonPressed(void)
{
	run(GPCApplication::EJob::kShutdown);

	return;
}


bool SummaryWnd::keyPressed(const KeyPress &key)
{
	const ModifierKeys modifiers = key.getModifiers();
	if (key.isKeyCode(KeyPress::F1Key))
	{
		run(GPCApplication::EJob::kShowAboutWindow);
		return true; // true == consume the keystroke
	}
	else if (key.isKeyCode(KeyPress::F2Key) && modifiers.isShiftDown())
	{
		File f = cfg().getFile();
		f.revealToUser();
		return true; // true == consume the keystroke
	}
	else if (key.isKeyCode(KeyPress::F4Key) && modifiers.isShiftDown())
	{
		File f( get_log_filename() );
		f.startAsProcess();
		return true; // true == consume the keystroke
	}

	return false; // false == keystroke not handled
}
