/* Example file showing how to use the DarkHelp C++ API for darknet.
 * Source code for this post:  https://www.ccoderun.ca/programming/2019-08-25_Darknet_C_CPP/
 * Stephane Charette <stephanecharette@gmail.com>
 *
 * License:  This short sample source code file is public domain.
 *
 * Build like this:        g++ test.cpp -ldarkhelp -ldarknet $(pkg-config --libs opencv)
 * Then run it like this:  ./a.out barcode_*.jpg
 */

#include <DarkHelp.hpp>

int main(int argc, char *argv[])
{
	const std::string config_file	= "stone_barcodes_yolov3-tiny.cfg";
	const std::string weights_file	= "stone_barcodes_yolov3-tiny_final.weights";
	const std::string names_file	= "stone_barcodes.names";

	// load the neural network (config, weights, and class names)
	DarkHelp darkhelp(config_file, weights_file, names_file);

	// set a few DarkHelp options (see the docs or the .hpp for all the options)
	darkhelp.threshold						= 0.50; // 50% threshold is perhaps too high...?
	darkhelp.names_include_percentage		= true;
	darkhelp.annotation_include_duration	= true;
	darkhelp.annotation_include_timestamp	= false;

	// loop through all the image filenames
	for (int idx = 1; idx < argc; idx++)
	{
		const std::string filename = argv[idx];

		std::cout << "getting predictions on " << filename << std::endl;
		const auto results = darkhelp.predict(filename);
		std::cout << "prediction took " << darkhelp.duration_string() << std::endl;

		for (const auto & detection : results)
		{
			std::cout
				<< "-------------------------"					<< std::endl
				<< "  name:   " << detection.name				<< std::endl
				<< "  rect:   "
				<< "x="			<< detection.rect.x				<< " "
				<< "y="			<< detection.rect.y				<< " "
				<< "w="			<< detection.rect.width			<< " "
				<< "h="			<< detection.rect.height		<< std::endl
				<< "  class:  " << detection.best_class			<< std::endl
				<< "  prob.:  " << detection.best_probability	<< std::endl;
		}

		// annotate the image we used in the previous call to predict(), and display it on the screen
		cv::Mat image = darkhelp.annotate();
		cv::imshow("prediction", image);
		cv::waitKey();
	}

	return 0;
}

