/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_base.cpp 1512 2016-01-01 09:06:13Z stephane $
 */

#include "sg_base.hpp"
#include "sg_version.hpp"
#include <cxxabi.h>


std::string SG::get_version( void )
{
	/// Format should be similar to @p "0.0.1-1443".

	return SG_VERSION;
}


std::string SG::demangle( const std::string &name )
{
	std::string demanged_name = name;

	int status = -1;
	char *ptr = abi::__cxa_demangle( name.c_str(), nullptr, nullptr, &status );

	if (status == 0 && ptr)		demanged_name = ptr;
	if (ptr)					free(ptr);

	return demanged_name;
}
