/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_101020011_TemperatureAndHumiditySensor.cpp 1729 2016-03-30 07:04:48Z stephane $
 */

#include "sg_101020011_TemperatureAndHumiditySensor.hpp"
#include "sg++.hpp"


SG::TemperatureAndHumiditySensor::~TemperatureAndHumiditySensor( void )
{
//	SG::SGpp::get().gpio.gpio_unexport( 2 );	// P9_22 -- GPIO_2

	return;
}


SG::TemperatureAndHumiditySensor::TemperatureAndHumiditySensor( const std::string &n ) :
		GroveI2C( SG::EGroveType::kTemperatureAndHumiditySensor, n )
{
//	SG::SGpp::get().gpio.gpio_export( 2, GpioManagement::EDirection::kOutput );

	return;
}


SG::TemperatureAndHumiditySensor::TemperatureAndHumiditySensor( const SG::TemperatureAndHumiditySensor &rhs ) :
		GroveI2C( rhs.get_type(), rhs.get_name() )
{
	return;
}


SG::TemperatureAndHumiditySensor &SG::TemperatureAndHumiditySensor::operator=( const SG::TemperatureAndHumiditySensor &rhs )
{
	if (this != &rhs)
	{
		GroveI2C::operator=( rhs );
	}

	return *this;
}


bool SG::TemperatureAndHumiditySensor::operator==( const SG::TemperatureAndHumiditySensor &rhs ) const
{
	return GroveI2C::operator==(rhs);
}
