/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_101020011_TemperatureAndHumiditySensor.hpp 1729 2016-03-30 07:04:48Z stephane $
 */

#pragma once

#include "sg_GroveI2C.hpp"


namespace SG
{
	/** Temperature and humidity sensor.
	 *
	 * Description | Image
	 * ------------|------
	 * Chainable RGB LED connected to the Grove UART interface. <br/>The light in this example was enabled from the command-line with @p "sudo seeedgrove chainable_rgb_led 255 128 0". | @image html ChainableRGBLED_1.jpg
	 * GROVE cable connects to the @p 'in' side of the chainable RGB LED. | @image html ChainableRGBLED_2.jpg
	 *
	 * @see http://www.seeedstudio.com/wiki/Grove_-_Temperature_and_Humidity_Sensor
	 * @see http://www.seeedstudio.com/depot/Grove-TempHumi-Sensor-p-745.html
	 */
	class TemperatureAndHumiditySensor : public GroveI2C
	{
		public:

			/// Destructor.
			virtual ~TemperatureAndHumiditySensor( void );

			/// Constructor.
			TemperatureAndHumiditySensor( const std::string &n="" );

			/// Copy constructor.
			TemperatureAndHumiditySensor( const TemperatureAndHumiditySensor &rhs );

			/// Assignment.
			TemperatureAndHumiditySensor &operator=( const TemperatureAndHumiditySensor &rhs );

			/// Test object equality. @{
			bool operator==( const TemperatureAndHumiditySensor &rhs ) const;
			bool operator!=( const TemperatureAndHumiditySensor &rhs ) const { return ! operator==(rhs); }
			/// @}
	};
}
