/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_104030011_OLED96.cpp 1731 2016-03-31 13:10:51Z stephane $
 */

#include "sg_104030011_OLED96.hpp"
#include "sg++.hpp"
#include "sg_i2c-dev.h"

#include <sstream>
#include <iomanip>
#include <system_error>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>


bool SG::OLED96::auto_detect(void)
{
	/** @return @p true if it is possible that a OLED 96x96 is connected to the I2C bus.
	 * @return @p false if it seems as if the I2C bus isn't connected to a OLED 96x96.
	 */

	const int fd = open( "/dev/i2c-1", O_RDWR );
	if (fd < 0)
	{
		return false;
	}

	const int addr = 0x3c;
	const int rc = ioctl( fd, I2C_SLAVE, addr );
	if (rc < 0)
	{
		close( fd );
		return false;
	}

	return true;
}


SG::OLED96::~OLED96( void )
{
	close( i2c_file_handle );
	i2c_file_handle = -1;
	
	return;
}


SG::OLED96::OLED96( const uint8_t addr, const std::string &n ) :
		GroveI2C( SG::EGroveType::kI2CADC, n ),
		i2c_address( addr ),
		i2c_file_handle( -1 )
{
	const std::string filename = "/dev/i2c-1";
	i2c_file_handle = open(filename.c_str(), O_RDWR);
	if (i2c_file_handle < 0)
	{
		/// @throw std::system_error if the I2C device cannot be opened.
		const std::error_code ec( errno, std::system_category());
		throw std::system_error( ec, "SG++ failed to open " + filename + " for read/write" );
	}
	
	const int i = static_cast<int>(i2c_address);
	const int rc = ioctl( i2c_file_handle, I2C_SLAVE, i );
	if (rc < 0)
	{
		close( i2c_file_handle );
		
		std::stringstream ss;
		ss << std::hex << std::setfill('0') << std::setw(2) << i;
		
		/// @throw std::system_error if the I2C slave address cannot be set.
		const std::error_code ec( errno, std::system_category());
		throw std::system_error( ec, "SG++ failed to set the I2C slave address to 0x" + ss.str() );
	}
	
	return;
}
