/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_GroveGPIO.cpp 1512 2016-01-01 09:06:13Z stephane $
 */

#include "sg_GroveGPIO.hpp"
#include "sg++.hpp"
#include <thread>


SG::GroveGPIO::GroveGPIO( const SG::EGroveType t, const std::string &n ) :
		GroveBase( t, n )
{
	return;
}


SG::GroveGPIO::~GroveGPIO( void )
{
	return;
}


SG::GroveGPIO &SG::GroveGPIO::send_byte( uint8_t byte )
{
	// inspiration for this function came from http://www.seeedstudio.com/wiki/Grove_-_Chainable_RGB_LED#With_Beaglebone_Green

	/* Pause for the clock line is 0.00002 seconds.  What does this mean?
	 * 
	 * 1s			= 1/1s				(or 1 second)
	 * 0.001s		= 1/1000s			(or 1 millisecond)
	 * 0.000020s	= ...?
	 * 0.000001s	= 1/1,000,000s		(or 1 microsecond)
	 * 0.000000001s	= 1/1,000,000,000s	(or 1 nanosecond)
	 *
	 * So 0.00002 seconds is 20 microseconds.
	 */
	const auto pause_duration = std::chrono::microseconds(20);

	GpioManagement &gm = SG::SGpp::get().gpio;

	// send one bit at a time, starting with the MSB
	for ( size_t bit_count = 0; bit_count < 8; bit_count ++ )
	{
		if ( byte & 0x80 )
		{
			// this bit is set
			gm.set_high( 3 );
		}
		else
		{
			// this bit is not set
			gm.set_low( 3 );
		}

		// clock the bit
		gm.set_low( 2 );
		std::this_thread::sleep_for( pause_duration );
		gm.set_high( 2 );
		std::this_thread::sleep_for( pause_duration );

		// move to the next bit
		byte <<= 1;
	}

	return *this;
}
