/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg++.hpp 1731 2016-03-31 13:10:51Z stephane $
 */

#pragma once

/** @file
 * This is the central include file for SeeedGrove++.
 * Include this file, and you'll have access to the entire SG namespace.
 */

#include <string>
#include "sg_base.hpp"
#include "sg_groves.hpp"
#include "sg_all_groves.hpp"
#include "sg_GpioManagement.hpp"
#include "sg_BeagleBone.hpp"


namespace SG
{
	/** The SGpp class is the central class to the Seeed Grove ++ library.  Instantiate the SGpp constructor by calling
	 * @ref SG::SGpp::get() which will get the singleton.  For example:
	 *
	 * ~~~~
	 * #include <SG/sg++.hpp>
	 * 
	 * int main(...)
	 * {
	 *     SG::SGpp::get().initialize();
	 *     ...
	 * ~~~~
	 * The destructor will automatically call @ref cleanup() when the static singleton SGpp object goes out of scope.
	 */
	class SGpp final
	{
		public:

			/// Destructor.  This automatically calls @ref cleanup().
			~SGpp( void );

			/// Get the SGpp singleton.  This will also indirectly ensure the Seeed Grove ++ library is initialized.
			static SGpp &get( void );

			/** Initialize Seeed Grove ++.  This is called automatically by the constructor, or can be manually called.
			 * This method can be safely called multiple times.  @see @ref is_initialized()  @see @ref cleanup()
			 */
			SGpp &initialize( void );

			/** Cleanly shutdown (where possible) Seeed Grove ++.  This is called automatically by the destructor, or
			 * can be manually called.  This method can be safely called multiple times.  @see @ref initialize()
			 */
			SGpp &cleanup( void );

			/// Determine if Seeed Grove ++ has been initialized.  @see @ref initialize()  @see @ref cleanup()
			bool is_initialized( void ) const { return initialized; }

			/// Access to GPIO functionality.
			GpioManagement &gpio;

		private:

			/// Constructor.  This calls @ref initialize().
			SGpp( void );

			/// Determine if Seeed Grove ++ has been initialized.  @see @ref is_initialized()
			bool initialized;
	};
}
