/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_FD.cpp 1808 2016-04-28 22:17:03Z stephane $
 */

#include "sg_FD.hpp"
#include <system_error>
#include <unistd.h>
#include <fcntl.h>


SG::FD::FD(const int i) :
		fd(i)
{
	return;
}


SG::FD::FD(const std::string &filename) :
		FD( filename, O_RDWR )
{
	return;
}


SG::FD::FD(const std::string &filename, const int mode) :
		FD()
{
	fd = open(filename.c_str(), mode);
	if (fd < 0)
	{
		/// @throw std::system_error if the file cannot be opened for read/write access.
		const std::error_code ec( errno, std::system_category());
		throw std::system_error( ec, "SG++ failed to open " + filename );
	}

	return;
}


SG::FD::~FD(void)
{
	if (fd >= 0)
	{
		close(fd);
		fd = -1;
	}

	return;
}
