/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_Font.hpp 1776 2016-04-17 04:52:34Z stephane $
 */

#pragma once

// Central include file for SeeedGrove++ is "sg++.hpp".

#include <memory>
#include "sg_Monospace.hpp"
#include "sg_8x8_CapRouge.hpp"
#include "sg_8x8_CourierNew.hpp"
#include "sg_8x8_DejaVuSans.hpp"
#include "sg_8x8_UbuntuMono.hpp"


namespace SG
{
	namespace Font
	{
		/// Enumerator for the various fonts available.
		enum class EType
		{
			kInvalid		= 0,
			k8x8CapRouge	,		///< @image html CapRouge_8x8.png "8x8 Cap Rouge"
			k8x8CourierNew	,		///< @image html CourierNew_8x8.png "8x8 Courier New"
			k8x8DejaVuSans	,		///< @image html DejaVuSansMono_8x8.png "8x8 DejaVu Sans"
			k8x8UbuntuMono	,		///< @image html UbuntuMono_8x8.png "8x8 Ubuntu Mono"
		};

		/// Get a shared pointer to the specified font.
		std::shared_ptr<SG::Font::Monospace> get( const EType type );
	}
}
