/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_GroveBase.hpp 1753 2016-04-10 22:29:30Z stephane $
 */

#pragma once

// Central include file for SeeedGrove++ is "sg++.hpp".

#include "sg_groves.hpp"


namespace SG
{
	class GroveBase
	{
		public:

			/// Destructor.
			virtual ~GroveBase( void );
			
			/// Constructor.
			GroveBase( const SG::EGroveType t=SG::EGroveType::kUnknown, const std::string &n="" );

			/// Copy constructor.
			GroveBase( const GroveBase &rhs );

			/// Assignment.
			GroveBase &operator=( const GroveBase &rhs );

			/// Test object equality. @{
			bool operator==( const GroveBase &rhs ) const;
			bool operator!=( const GroveBase &rhs ) const { return ! operator==(rhs); }
			/// @}

			virtual uint32_t	get_sku			( void ) const { return get_sku_from_grove_type( grove_type );	}	///< Return a guess as to the Seeed SKU number based on the grove type.
			virtual std::string	get_type_name	( void ) const { return SG::to_string( grove_type );			}	///< Return a short text string representing the grove type.
			virtual EGroveType	get_type		( void ) const { return grove_type;								}	///< Return the grove type.
			virtual std::string	get_name		( void ) const { return grove_name;								}	///< Return the user-supplied name.
			virtual std::string	get_description	( void ) const;														///< Return a multi-word 1-line description of this object.
			virtual bool		is_grove_uart	( void ) const = 0;													///< Determine if this is a Grove UART device.	@see @ref SG::GroveUART
			virtual bool		is_grove_i2c	( void ) const = 0;													///< Determine if this is a Grove I2C device.	@see @ref SG::GroveI2C
			virtual bool		is_grove_gpio	( void ) const = 0;													///< Determine if this is a Grove GPIO device.	@see @ref SG::GroveGPIO

			/// Grove type.
			EGroveType	grove_type;

			/// User-supplied name.
			std::string	grove_name;
	};
}
