/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_GroveI2C.hpp 1739 2016-04-04 07:42:44Z stephane $
 */

#pragma once

// Central include file for SeeedGrove++ is "sg++.hpp".

#include "sg_groves.hpp"
#include "sg_GroveBase.hpp"


namespace SG
{
	/** Base class for Groves that use the I2C (Inter-Integrated Circuit) interface.
	 *
	 * @see @ref GroveI2CAnalog
	 * @see @ref GroveI2CDigital
	 */
	class GroveI2C : public GroveBase
	{
		public:

			/// Constructor.
			GroveI2C( const SG::EGroveType t = SG::EGroveType::kUnknown, const std::string &n = "" );

			/// Destructor.
			virtual ~GroveI2C( void );

			virtual bool is_grove_uart	( void ) const { return false;	}	///< This is always @p false for GroveI2C.
			virtual bool is_grove_i2c	( void ) const { return true;	}	///< This is always @p true for GroveI2C.
			virtual bool is_grove_gpio	( void ) const { return false;	}	///< This is always @p false for GroveI2C.
			virtual bool is_analog		( void ) const = 0;					///< Determine if this is a Grove I2C analog device.
			virtual bool is_digital		( void ) const = 0;					///< Determine if this is a Grove I2C digital device.
	};
}
