/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: ChainableRGBLED.cpp 1512 2016-01-01 09:06:13Z stephane $
 */

#include "sg++.hpp"
#include <gtest/gtest.h>


TEST( ChainableRGBLED, construct_and_compare )
{
	SG::ChainableRGBLED rgb_led_1;
	SG::ChainableRGBLED rgb_led_2(2);
	SG::ChainableRGBLED rgb_led_3(3, "testing");
	SG::ChainableRGBLED rgb_led_4(0, "blah", true);

	SG::ChainableRGBLED rgb_led_5 = rgb_led_3;

	rgb_led_1 = rgb_led_2;

	ASSERT_EQ( rgb_led_1, rgb_led_2 );
	ASSERT_EQ( rgb_led_3, rgb_led_5 );
	ASSERT_NE( rgb_led_1, rgb_led_3 );
	ASSERT_NE( rgb_led_4, rgb_led_5 );

	SG::ChainableRGBLED array[10];
	array[0].turn_off();
}


TEST( ChainableRGBLED, turn_off_and_turn_on )
{
	SG::ChainableRGBLED rgb_led;
	rgb_led.set_RGB( 128, 160, 192 );
	ASSERT_EQ( rgb_led.red	, 128 );
	ASSERT_EQ( rgb_led.green, 160 );
	ASSERT_EQ( rgb_led.blue	, 192 );

	rgb_led.turn_off();
	ASSERT_EQ( rgb_led.red	, 128 );
	ASSERT_EQ( rgb_led.green, 160 );
	ASSERT_EQ( rgb_led.blue	, 192 );

	// 2nd consecutive "turn off" command is intentional
	rgb_led.turn_off();
	ASSERT_EQ( rgb_led.red	, 128 );
	ASSERT_EQ( rgb_led.green, 160 );
	ASSERT_EQ( rgb_led.blue	, 192 );

	rgb_led.turn_on();
	ASSERT_EQ( rgb_led.red	, 128 );
	ASSERT_EQ( rgb_led.green, 160 );
	ASSERT_EQ( rgb_led.blue	, 192 );

	// setting explicit temporary colours shouldn't change the values previously saved
	rgb_led.turn_on( 1, 2, 3 );
	ASSERT_EQ( rgb_led.red	, 128 );
	ASSERT_EQ( rgb_led.green, 160 );
	ASSERT_EQ( rgb_led.blue	, 192 );
}


TEST( ChainableRGBLED, html_colour_parsing )
{
	SG::ChainableRGBLED rgb_led;

	rgb_led.set_RGB( "#fff" );
	ASSERT_EQ( rgb_led.red	, 255 );
	ASSERT_EQ( rgb_led.green, 255 );
	ASSERT_EQ( rgb_led.blue	, 255 );

	rgb_led.set_RGB( "#a0b0cc" );
	ASSERT_EQ( rgb_led.red	, 160 );
	ASSERT_EQ( rgb_led.green, 176 );
	ASSERT_EQ( rgb_led.blue	, 204 );

	rgb_led.set_RGB( "#000" );
	ASSERT_EQ( rgb_led.red	, 0 );
	ASSERT_EQ( rgb_led.green, 0 );
	ASSERT_EQ( rgb_led.blue	, 0 );

	rgb_led.set_RGB( "a0b0cc" );
	ASSERT_EQ( rgb_led.red	, 160 );
	ASSERT_EQ( rgb_led.green, 176 );
	ASSERT_EQ( rgb_led.blue	, 204 );

	rgb_led.set_RGB( "000" );
	ASSERT_EQ( rgb_led.red	, 0 );
	ASSERT_EQ( rgb_led.green, 0 );
	ASSERT_EQ( rgb_led.blue	, 0 );

	// this one should fail to parse, so rgb is set to white
	rgb_led.set_RGB( "test" );
	ASSERT_EQ( rgb_led.red	, 255 );
	ASSERT_EQ( rgb_led.green, 255 );
	ASSERT_EQ( rgb_led.blue	, 255 );

	rgb_led.set_RGB( "#abc" );
	ASSERT_EQ( rgb_led.red	, 170 );
	ASSERT_EQ( rgb_led.green, 187 );
	ASSERT_EQ( rgb_led.blue	, 204 );

	// this one should fail to parse, so rgb is set to white
	rgb_led.set_RGB( "" );
	ASSERT_EQ( rgb_led.red	, 255 );
	ASSERT_EQ( rgb_led.green, 255 );
	ASSERT_EQ( rgb_led.blue	, 255 );

	// reset rgb to known values after the last pasrse failure
	rgb_led.red		= 128;
	rgb_led.green	= 128;
	rgb_led.blue	= 128;

	// this one should fail to parse, so failed value is set to white
	rgb_led.set_RGB( "#aabbzz" );
	ASSERT_EQ( rgb_led.red	, 170 );
	ASSERT_EQ( rgb_led.green, 187 );
	ASSERT_EQ( rgb_led.blue	, 255 );

	// reset rgb to known values after the last pasrse failure
	rgb_led.red		= 128;
	rgb_led.green	= 128;
	rgb_led.blue	= 128;

	// this one should fail to parse, so failed value is set to white
	rgb_led.set_RGB( "#xxyyzz" );
	ASSERT_EQ( rgb_led.red	, 255 );
	ASSERT_EQ( rgb_led.green, 255 );
	ASSERT_EQ( rgb_led.blue	, 255 );
}
