/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_GroveGPIO.hpp 1862 2016-05-25 00:06:15Z stephane $
 */

#pragma once

// Central include file for SeeedGrove++ is "sg++.hpp".

#include "sg_groves.hpp"
#include "sg_GroveBase.hpp"


namespace SG
{
	/** Base class for Groves that use the UART interface in GPIO mode (General Purpose Input Output).
	 * When looking at the top of a %BeagleBone Green with the network interface towards the top and the Grove
	 * interfaces at the bottom, this is the right-hand-side Grove interface labelled @p J5.  On the board, you'll
	 * also see the labels
	 * @p RXD, @p TXD, @p 3V3, and @p GND.
	 *
	 * @see @ref GroveUART
	 * @see @ref GroveI2C
	 */
	class GroveGPIO : public GroveBase
	{
		public:

			/// Constructor.
			GroveGPIO( const SG::EGroveType t=SG::EGroveType::kUnknown, const std::string &n="" );

			/// Destructor.
			virtual ~GroveGPIO( void );

			/// Send 16 bits (2 bytes).
			virtual GroveGPIO &send_2_bytes( uint16_t bits );

			/// Send a single byte.
			virtual GroveGPIO &send_byte( uint8_t byte );

			virtual bool is_grove_uart	( void ) const { return false;	}
			virtual bool is_grove_i2c	( void ) const { return false;	}
			virtual bool is_grove_gpio	( void ) const { return true;	}
	};
}
