/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_FD.cpp 1855 2016-05-24 00:22:22Z stephane $
 */

#include "sg_FD.hpp"
#include "sg_base.hpp"
#include <system_error>
#include <unistd.h>
#include <fcntl.h>


SG::FD::FD(const int i) :
		fd(i)
{
	return;
}


SG::FD::FD(const std::string &filename) :
		FD( true, filename, O_RDWR )
{
	return;
}


SG::FD::FD(const std::string &filename, const int mode) :
		FD( true, filename, mode )
{
	return;
}


SG::FD::FD(const bool throw_on_error, const std::string &filename, const int mode) :
		FD()
{
	if (file_does_not_exist(filename))
	{
		if (throw_on_error)
		{
			/// @throw std::invalid_argument if the file does not exist.
			throw std::invalid_argument( "SG++ cannot open non-existent file " + filename );
		}
	}
	else
	{
		fd = open(filename.c_str(), mode);
		if (fd < 0)
		{
			if (throw_on_error)
			{
				/// @throw std::system_error if the file cannot be opened for the given read/write access mode.
				const std::error_code ec( errno, std::system_category());
				throw std::system_error( ec, "SG++ failed to open " + filename );
			}
		}
	}

	return;
}


SG::FD::~FD(void)
{
	if (fd >= 0)
	{
		close(fd);
		fd = -1;
	}

	return;
}
