/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_Font.hpp 1831 2016-05-06 16:25:21Z stephane $
 */

#pragma once

// Central include file for SeeedGrove++ is "sg++.hpp".

#include <memory>
#include "sg_Monospace.hpp"
#include "sg_8x8_CapRouge.hpp"
#include "sg_8x8_CourierNew.hpp"
#include "sg_8x8_DejaVuSans.hpp"
#include "sg_8x8_UbuntuMono.hpp"


namespace SG
{
	namespace Font
	{
		/// Enumerator for the various fonts available.
		enum class EType
		{
			kInvalid		= 0,
			k8x8CapRouge	,		///< @image html CapRouge_8x8.png "8x8 Cap Rouge"			@see @ref SG::Font::CapRouge
			k8x8CourierNew	,		///< @image html CourierNew_8x8.png "8x8 Courier New"		@see @ref SG::Font::CourierNew
			k8x8DejaVuSans	,		///< @image html DejaVuSansMono_8x8.png "8x8 DejaVu Sans"	@see @ref SG::Font::DejaVuSans
			k8x8UbuntuMono	,		///< @image html UbuntuMono_8x8.png "8x8 Ubuntu Mono"		@see @ref SG::Font::UbuntuMono
		};

		/// Get a shared pointer to the specified font.  @see @ref SG::CommonOLED::set_font()
		std::shared_ptr<SG::Font::Monospace> get( const EType type );
	}
}
