/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_104020001_VariableColorLED.cpp 1904 2016-06-15 04:20:07Z stephane $
 */

#include "sg_104020001_VariableColorLED.hpp"
#include "sg++.hpp"


SG::VariableColorLED::~VariableColorLED( void )
{
	if (turn_off_LED_when_destructing)
	{
		try
		{
			turn_off();
		}
		catch (...)
		{
			// ignore exceptions; don't throw from the destructor
		}
	}

	SG::SGpp::get().gpio.gpio_unexport( 2 );	// P9_22 -- GPIO_2

	return;
}


SG::VariableColorLED::VariableColorLED( const std::string &n, const bool turn_off_at_destruction ) :
		GroveGPIO( SG::EGroveType::kVariableColorLED, n ),
		turn_off_LED_when_destructing( turn_off_at_destruction )
{
	SG::SGpp::get().gpio.gpio_export( 2, GpioManagement::EDirection::kOutput );

	return;
}


SG::VariableColorLED &SG::VariableColorLED::turn_off( void )
{
	SG::SGpp::get().gpio.set_high(2);
	std::this_thread::sleep_for( std::chrono::milliseconds(5) );

	return *this;
}


SG::VariableColorLED &SG::VariableColorLED::turn_on( void )
{
	SG::SGpp::get().gpio.set_low(2);
	std::this_thread::sleep_for( std::chrono::milliseconds(5) );
	
	return *this;
}


SG::VariableColorLED &SG::VariableColorLED::turn_on( const std::chrono::high_resolution_clock::duration &duration )
{
	// turn on
	SG::SGpp::get().gpio.set_low(2);
	std::this_thread::sleep_for( duration );

	// ...then turn off again
	SG::SGpp::get().gpio.set_high(2);
	std::this_thread::sleep_for( duration );

	return *this;
}


SG::VariableColorLED &SG::VariableColorLED::turn_off( const std::chrono::high_resolution_clock::duration &duration )
{
	// turn off
	SG::SGpp::get().gpio.set_high(2);
	std::this_thread::sleep_for( duration );

	// ...then turn on again
	SG::SGpp::get().gpio.set_low(2);
	std::this_thread::sleep_for( duration );

	return *this;
}
