/* Seeed Grove ++ (C) 2015-2016 Stephane Charette <stephanecharette@gmail.com>
 * $Id: sg_104030011_OLED096.cpp 1753 2016-04-10 22:29:30Z stephane $
 */

#include "sg_104030011_OLED096.hpp"


SG::OLED096::~OLED096( void )
{
	return;
}


SG::OLED096::OLED096( const std::string &n, const SG::GroveI2CDigital::I2CAddress addr ) :
		SG::CommonOLED( SG::EGroveType::kOLEDDisplay0_96, n, addr )
{
	return;
}


SG::OLED096 &SG::OLED096::reset(void)
{
	/** The OLED096 uses the Solomon Systech SSD1327 (128x128 dot matrix).  Inspiration for the
	 * commands in @p reset() came from SSD1327_datasheet.pdf, sections 9-10, pages 36-54.
	 */

	I2CBlock block =
	{
		0xfd,	0x12,	// [page 39] unlock
		0xae,			// [page 37] turn screen off
		0x2e,			// [page 40] stop scrolling
		0x15,			// [page 36] set column address
				0x00,	// [page 36] set column address: A: start address
				0x3f,	// [page 36] set column address: B: end address
		0x75,			// [page 36] set row address
				0x00,	// [page 36] set row address: A: start address
				0x7f,	// [page 36] set row address: B: end address
		0x81,	0x7f,	// [page 36] set contrast
		0xa0,	0x00,	// [page 36] set re-map
		0xa1,	0x00,	// [page 36] set display start line
		0xa2,	0x00,	// [page 37] set display offset
		0xa4,			// [page 37] normal display
		0xa8,	0x7f,	// [page 37] set MUX ratio
		0xab,	0x01,	// [page 37] enable internal VDD regulator
		0xb1,	0x74,	// [page 37] set phase length
		0xb3,	0x00,	// [page 38] set front clock divider/oscillator frequency
		0xb5,	0x02,	// [page 38] GPIO
		0xb6,	0x04,	// [page 38] set second pre-charge period
		0xb9,			// [page 38] use the default gray scale
		0xbc,	0x05,	// [page 39] set pre-charge voltage
		0xbe,	0x05,	// [page 39] set COM deselect voltage level
		0xd5,	0x60,	// [page 39] function selection B
		0x26,			// [page 40] horizontal scroll setup
				0x00,	// [page 40] horizontal scroll: A: filler byte
				0x00,	// [page 40] horizontal scroll: B: start row address
				0x00,	// [page 40] horizontal scroll: C: time interval
				0x7f,	// [page 40] horizontal scroll: D: end row address
				0x00,	// [page 40] horizontal scroll: E: start column address
				0x3f,	// [page 40] horizontal scroll: F: end column address
				0x00	// [page 40] horizontal scroll: G: filler byte
	};

	write_block		(block);
	clear_screen	();
	turn_on			();

	return *this;
}


SG::OLED096 &SG::OLED096::clear_screen(void)
{
	/// @todo TODO boooo
	return *this;
}
