/* CamCap (C) 2017 Stephane Charette <stephanecharette@gmail.com>
 * $Id: CamCap_format.cpp 2154 2017-02-13 19:50:22Z stephane $
 */

/** @file
 * Methods related to getting and setting the image format.
 */

#include "CamCap.hpp"
#include "CamCap_defines.h"
#include <limits>


v4l2_format CC::Device::set_format( v4l2_format format )
{
	if (is_not_initialized())
	{
		initialize();
	}

	release_memory_mapped_buffers();

	selected_format = format;
	xioctl( VIDIOC_S_FMT, &selected_format, "VIDIOC_S_FMT" );

	return selected_format;
}


v4l2_format CC::Device::set_format( v4l2_fmtdesc format_description, const size_t width, const size_t height )
{
	if (is_not_initialized())
	{
		initialize();
	}

	ZERO(selected_format);
	selected_format.type				= format_description.type;
	selected_format.fmt.pix.width		= width;
	selected_format.fmt.pix.height		= height;
	selected_format.fmt.pix.pixelformat	= format_description.pixelformat;	// for example, V4L2_PIX_FMT_YUYV, V4L2_PIX_FMT_MJPEG, or V4L2_PIX_FMT_RGB24
	selected_format.fmt.pix.field		= V4L2_FIELD_NONE;
	selected_format.fmt.pix.priv		= V4L2_PIX_FMT_PRIV_MAGIC;

	return set_format( selected_format );
}


v4l2_format CC::Device::set_format( const size_t width, const size_t height )
{
	if (is_not_initialized())
	{
		initialize();
	}

	// put a cap on the width and height since V4L2 has them as uint32_t
	const uint32_t w = std::min( (uint32_t)width	, std::numeric_limits<uint32_t>::max() );
	const uint32_t h = std::min( (uint32_t)height	, std::numeric_limits<uint32_t>::max() );

	selected_format.fmt.pix.width	= w;
	selected_format.fmt.pix.height	= h;

	return set_format( selected_format );
}


v4l2_format CC::Device::set_format( const int pixel_format, const size_t width, const size_t height )
{
	if (is_not_initialized())
	{
		initialize();
	}

	selected_format.type = pixel_format;

	return set_format( width, height );
}
