#!/bin/bash
# C Code Run (C) 2016-2017 Stephane Charette <stephanecharette@gmail.com>
# $Id: ccr_hostname.sh 2086 2017-01-09 10:15:39Z stephane $
#
# https://www.ccoderun.ca/bbtools/
#
# Return the usual BeagleBone type, such as BBB, BBW, BBGW, etc.


name=""
if [ -e /proc/device-tree/model ]; then
	model="$(cat /proc/device-tree/model)"
	if [[ "${model}" =~ BeagleBone ]]; then
		name="${name}BB"
	fi
	if [[ "${model}" =~ White ]]; then
		name="${name}W"
	fi
	if [[ "${model}" =~ Black ]]; then
		name="${name}B"
	fi
	if [[ "${model}" =~ Green ]]; then
		name="${name}G"
	fi
	if [[ "${model}" =~ Blue ]]; then
		name="${name}BL"
	fi
	if [[ "${model}" =~ Wireless ]]; then
		name="${name}W"
	fi
elif [ -e /sys/devices/virtual/dmi/id/product_name ]; then
	name="$(cat /sys/devices/virtual/dmi/id/product_name | tr -c -d '0-9A-Za-z')"
else
	name="unknown"
fi

echo "${name}"


exit 0
