#!/bin/bash
# C Code Run (C) 2016-2017 Stephane Charette <stephanecharette@gmail.com>
# $Id: ccr_hostname.sh 2116 2017-01-18 13:13:47Z stephane $
#
# https://www.ccoderun.ca/bbtools/
#
# Update the hostname.


# must be root to change the hostname
if (( EUID != 0 )); then
	logger --id --priority user.error --stderr "$0: must be root to change the hostname"
	exit 1
fi


mkdir -p /opt/ccr/files


if [ "$1" != "" ]; then
	# user has provided a hostname they want used
	echo -n "$@" | tr 'A-Z' 'a-z' | tr -c -d '0-9a-z-' > /opt/ccr/files/hostname.ccr
fi


if [ ! -e /opt/ccr/files/hostname.ccr ]; then
	# hostname hasn't been set yet, so create something usable with the machine ID and the device type
	id="0001"
	if [ -e /etc/machine-id ]; then
		id="$(cut -c-4 /etc/machine-id)"
	elif [ -e /var/lib/dbus/machine-id ]; then
		id="$(cut -c-4 /var/lib/dbus/machine-id)"
	fi

	echo -n "ccr-$(ccr_bbtype.sh)-${id}" | tr 'A-Z' 'a-z' > /opt/ccr/files/hostname.ccr
fi


old_hostname="$(cat /etc/hostname)"
new_hostname="$(cat /opt/ccr/files/hostname.ccr)"

if [ "${new_hostname}" = "" ]; then
	logger --id --priority user.error --stderr "$0: failed to get the hostname from /opt/ccr/hostname.ccr"
	exit 1
fi


if [ "${old_hostname}" != "${new_hostname}" ]; then
	logger --id --priority user.notice --stderr "$0: changing hostname from '${old_hostname}' to '${new_hostname}'"
	hostnamectl set-chassis embedded
	hostnamectl set-hostname "${new_hostname}"
	sed --in-place --expression "s:${old_hostname}:${new_hostname}:g" /etc/hosts

	grep --quiet "${new_hostname}" /etc/hosts
	if [ $? -ne 0 ]; then
		# something is wrong -- add a new line to ensure we can lookup our hostname
		echo "127.0.1.1 ${new_hostname}.localdomain ${new_hostname}" >> /etc/hosts
	fi
fi


exit 0
