#!/bin/bash
# C Code Run (C) 2016-2017 Stephane Charette <stephanecharette@gmail.com>
# $Id: ccr_log.sh 2086 2017-01-09 10:15:39Z stephane $
#
# https://www.ccoderun.ca/bbtools/
#
# Log an external event.


url="https://www.ccoderun.ca/ccr/device.html"
if [ -e /opt/ccr/files/log.ccr ]; then
	. /opt/ccr/files/log.ccr
elif (( EUID == 0 )); then
	# normally, only root can write to this directory
	echo "url='${url}'" >/opt/ccr/files/log.ccr
fi


if [ "$1" != "" ]; then
	# wget will take care of URL encoding
	url="${url}?m=$@"
fi


if [ -e /etc/machine-id ]; then
	machine_id=$(cat /etc/machine-id)
elif [ -e /var/lib/dbus/machine-id ]; then
	machine_id=$(cat /var/lib/dbus/machine-id)
else
	machine_id="unknown"
fi


logger --id --priority user.notice "$0: CCR ID=${machine_id}: $@"


wget	--quiet								\
		--output-file=/dev/null				\
		--output-document=/dev/null			\
		--no-use-server-timestamps			\
		--no-http-keep-alive				\
		--retry-connrefused					\
		--waitretry=30s						\
		--timeout=10						\
		--tries=5							\
		--no-cache							\
		--user-agent="CCR ID=${machine_id}"	\
		"${url}"


exit 0
