#!/bin/bash
# C Code Run (C) 2016-2017 Stephane Charette <stephanecharette@gmail.com>
# $Id: ccr_misc.sh 2087 2017-01-10 18:32:41Z stephane $
#
# https://www.ccoderun.ca/bbtools/
#
# Enable/disable the Connection Manager local DNS cache.


# must be root to make these changes
if (( EUID != 0 )); then
	logger --id --priority user.error --stderr "$0: must run as root"
	exit 1
fi


# should we be enabling or disabling the DNS cache?
enable_dns_cache=0
mkdir -p /opt/ccr/files
if [ -e /opt/ccr/files/dns_cache.ccr ]; then
	. /opt/ccr/files/dns_cache.ccr
fi
if [ "$1" = "disable" ]; then
	enable_dns_cache=0
elif [ "$1" = "enable" ]; then
	enable_dns_cache=1
elif [ "$1" != "" ]; then
	echo "Unknown parameter '$1'"
	exit 1
fi
echo "enable_dns_cache=${enable_dns_cache}" > /opt/ccr/files/dns_cache.ccr


# determine if we need to update the service and restart it
text_to_find="connmand -n"
if [ ${enable_dns_cache} -eq 0 ]; then
	text_to_find="connmand -r -n"
fi
grep --quiet "${text_to_find}" /lib/systemd/system/connman.service
if [ $? -ne 0 ]; then

	# the service file has the wrong parameters, so update it and restart ConnMan
	systemctl stop connman.service 
	if [ ${enable_dns_cache} -eq 0 ]; then
		logger --id --priority user.info --stderr "$0: disabling ConnMan's DNS cache"
		sed -i -e 's:connmand -n:connmand -r -n:g' /lib/systemd/system/connman.service
	else
		logger --id --priority user.info --stderr "$0: enabling ConnMan's DNS cache"
		sed -i -e 's:connmand -r -n:connmand -n:g' /lib/systemd/system/connman.service
	fi
	systemctl daemon-reload 
	systemctl start connman.service 
fi


exit 0
