#!/bin/bash -e
# C Code Run (C) 2016-2017 Stephane Charette <stephanecharette@gmail.com>
# $Id: ccr_misc.sh 2087 2017-01-10 18:32:41Z stephane $
#
# https://www.ccoderun.ca/bbtools/
#
# Enable/disable the Ubuntu repos.


# must be root to make these changes
if (( EUID != 0 )); then
	logger --id --priority user.error --stderr "$0: must run as root"
	exit 1
fi


enable="yes"
if [ "$1" != "" ]; then
	enable="$1"
fi

if [ "${enable,,}" = "y" -o "${enable,,}" = "yes" -o "${enable,,}" = "enable" ]; then
	logger --id --priority user.info --stderr "$0: enabling the Ubuntu repos"

	cp -f /opt/ccr/files/ccr_ubuntu_repo.list /etc/apt/sources.list.d/
	apt-key list | grep --quiet "Ubuntu Archive"
	if [ $? -ne 0 ]; then
		logger --id --priority user.info --stderr "$0: adding the Ubuntu gpg keys"
		apt-key adv --recv-keys --keyserver keyserver.ubuntu.com 3B4FE6ACC0B21F32 40976EAF437D05B5
	fi
else
	logger --id --priority user.info --stderr "$0: disabling the Ubuntu repos"
	rm -f /etc/apt/sources.list.d/ccr_ubuntu_repo.list
fi

apt-get update


exit 0
