# JPEGWrap (C) 2017 Stephane Charette <stephanecharette@gmail.com>
# $Id: CM_definitions.cmake 2127 2017-01-27 23:41:11Z stephane $


ADD_DEFINITIONS ( "-std=gnu++11" )
ADD_DEFINITIONS ( "-Wall -Wextra -Werror -Wno-unused-parameter" )
ADD_DEFINITIONS ( "-DJW_VER=\"${JW_VERSION}\"" )

IF ( CMAKE_SIZEOF_VOID_P EQUAL 8 )
	SET ( JW_BIT_SIZE 64 )
ELSEIF ( CMAKE_SIZEOF_VOID_P EQUAL 4 )
	SET ( JW_BIT_SIZE 32 )
ELSE ()
	MESSAGE ( FATAL_ERROR "CMAKE_SIZEOF_VOID_P=${CMAKE_SIZEOF_VOID_P}" )
ENDIF ()

STRING (FIND "${CMAKE_CXX_COMPILER}" "arm-linux-gnueabihf-g++" pos)
IF ( ${pos} EQUAL -1 )
	SET ( JW_CROSS_COMPILE_FOR_ARM7 FALSE )
ELSE ()
	MESSAGE ( "Cross compiling for ARM7" )
	SET ( JW_CROSS_COMPILE_FOR_ARM7 TRUE )
ENDIF ()


STRING (FIND "${CMAKE_SYSTEM_PROCESSOR}" "arm" pos)
IF ( ${pos} EQUAL -1 )
	SET ( JW_COMPILE_FOR_ARM7 FALSE )
ELSE ()
	MESSAGE ( "Compiling for ARM" )
	SET ( JW_COMPILE_FOR_ARM7 TRUE )
ENDIF ()


IF ( ${JW_CROSS_COMPILE_FOR_ARM7} OR ${JW_COMPILE_FOR_ARM7} )
	SET ( JW_SYSTEM_NAME "armhf-${JW_BIT_SIZE}" )
ELSE ()
	IF ( JW_BIT_SIZE EQUAL 32 )
		SET ( JW_SYSTEM_NAME "x86-${JW_BIT_SIZE}" )
	ELSE ()
		SET ( JW_SYSTEM_NAME "amd-${JW_BIT_SIZE}" )
	ENDIF ()
ENDIF ()
