/* JPEGWrap (C) 2017 Stephane Charette <stephanecharette@gmail.com>
 * $Id: JW.hpp 2131 2017-01-29 12:14:40Z stephane $
 */


#pragma once

#include <string>
#include <cstdlib>
#include <jpeglib.h>


/// Base class.  Use @ref JWCompress or @ref JWDecompress instead of this class.
class JW
{
	public:

		/// Destructor.
		virtual ~JW( void );

		/** The filename used for input (decompress) or output (compress) if set via @ref set_file().  The only way to set
		 * the input or output file is to call @ref JWCompress::set_output_file() or @ref JWDecompress::set_input_file().
		 */
		virtual std::string get_filename( void ) const { return fname; }

		/// IJG's structures and pointers to those structures used by derived classes. @{
		jpeg_error_mgr			jerr;
		jpeg_error_mgr			*jerr_ptr;
		jpeg_compress_struct	*cinfo_ptr;
		jpeg_decompress_struct	*dinfo_ptr;
		/// @}

	protected:

		/// Constructor is protected.  Use the derived classes @ref JWCompress and @ref JWDecompress, not this base class.
		JW( void );

		/** Protected method to set the input or output file.  Use the equivalent functions in the derived classes
		 * instead.  @see @ref JWCompress::set_output_file() @see @ref JWDecompress::set_input_file()  @{
		 */
		virtual JW &set_file( const std::string &filename );
		virtual JW &set_file( FILE * f );
		/// @}

		/// The filename used for input (decompress) or output (compress) if set via @ref set_file(). @see @ref get_filename()
		std::string fname;

		/// Input/output file.  Used for output when compressing, and input when decompressing.
		FILE * file;
};

