/* JPEGWrap (C) 2017 Stephane Charette <stephanecharette@gmail.com>
 * $Id: JWDecompress.hpp 2128 2017-01-28 17:08:47Z stephane $
 */


#pragma once

#include "JW.hpp"


/// Use %JWDecompress to decompress an existing @p .jpg file to RGB image data.
class JWDecompress : public JW
{
	public:

		JWDecompress( void );
		virtual ~JWDecompress( void );

		/// Decompress the given data.
		virtual JWDecompress &decompress( void );

		/// Set the jpeg input file. @{
		inline virtual JWDecompress &set_input_file( const std::string &filename )	{ set_file( filename );	return *this;	}
		inline virtual JWDecompress &set_input_file( FILE * f )						{ set_file( f );		return *this;	}
		/// @}

		/// IJG's decompression structure.  @see jpeglib.h
		jpeg_decompress_struct dinfo;
};
