# SimpleMessageKeeper (C) 2017 Stephane Charette <stephanecharette@gmail.com>
# $Id: CM_definitions.cmake 2115 2017-01-18 11:30:41Z stephane $


ADD_DEFINITIONS ( "-std=gnu++11" )
ADD_DEFINITIONS ( "-Wall -Wextra -Werror -Wno-unused-parameter" )
ADD_DEFINITIONS ( "-DSMK_VER=\"${SMK_VERSION}\"" )

IF ( CMAKE_SIZEOF_VOID_P EQUAL 8 )
	SET ( SMK_BIT_SIZE 64 )
ELSEIF ( CMAKE_SIZEOF_VOID_P EQUAL 4 )
	SET ( SMK_BIT_SIZE 32 )
ELSE ()
	MESSAGE ( FATAL_ERROR "CMAKE_SIZEOF_VOID_P=${CMAKE_SIZEOF_VOID_P}" )
ENDIF ()

STRING (FIND "${CMAKE_CXX_COMPILER}" "arm-linux-gnueabihf-g++" pos)
IF ( ${pos} EQUAL -1 )
	SET ( SMK_CROSS_COMPILE_FOR_ARM7 FALSE )
ELSE ()
	MESSAGE ( "Cross compiling for ARM7" )
	SET ( SMK_CROSS_COMPILE_FOR_ARM7 TRUE )
ENDIF ()


STRING (FIND "${CMAKE_SYSTEM_PROCESSOR}" "arm" pos)
IF ( ${pos} EQUAL -1 )
	SET ( SMK_COMPILE_FOR_ARM7 FALSE )
ELSE ()
	MESSAGE ( "Compiling for ARM" )
	SET ( SMK_COMPILE_FOR_ARM7 TRUE )
ENDIF ()


IF ( ${SMK_CROSS_COMPILE_FOR_ARM7} OR ${SMK_COMPILE_FOR_ARM7} )
	SET ( SMK_SYSTEM_NAME "armhf-${SMK_BIT_SIZE}" )
ELSE ()
	IF ( SMK_BIT_SIZE EQUAL 32 )
		SET ( SMK_SYSTEM_NAME "x86-${SMK_BIT_SIZE}" )
	ELSE ()
		SET ( SMK_SYSTEM_NAME "amd-${SMK_BIT_SIZE}" )
	ENDIF ()
ENDIF ()
