/* SimpleMessageKeeper (C) 2017 Stephane Charette <stephanecharette@gmail.com>
 * $Id: main.cpp 2112 2017-01-18 06:22:54Z stephane $
 */


#include <iostream>
#include <unistd.h>
#include "smk.hpp"


int main( int argc, char *argv[] )
{
	try
	{
		SMK smk;

		const std::string arg0	= (argc > 0 ? argv[0] : "smk"	);
		const std::string cmd	= (argc > 1 ? argv[1] : "help"	);
		const std::string parm1	= (argc > 2 ? argv[2] : ""		);
		const std::string parm2	= (argc > 3 ? argv[3] : ""		);

			 if (cmd == "help"		|| argc <= 1						) smk.show_usage( arg0			);
		else if (cmd == "reset"		&& argc == 2						) smk.reset		(				);
		else if (cmd == "clean"		&& argc == 2						) smk.clean		(				);
		else if (cmd == "unique"	&& argc == 4						) smk.unique	( parm1, parm2	);
		else if (cmd == "add"		&& argc == 4						) smk.add		( parm1, parm2	);
		else if (cmd == "del"		&& argc == 3						) smk.del		( parm1			);
		else if (cmd == "dump"		&& argc == 2						) smk.dump		(				);
		else if (cmd == "show"		&& argc == 2						) smk.format	(				);
		else if (cmd == "get"		&& argc == 3 && parm1 == "all"		) smk.get_all	(				);
		else if (cmd == "get"		&& argc == 3 && parm1 == "recent"	) smk.get_recent(				);
		else if (cmd == "get"		&& argc == 3						) smk.get		( parm1			);
		else
		{
			std::cout << "Unknown command or incorrect number of parameters." << std::endl;
			return 1;
		}
	}
	catch ( const std::exception &e )
	{
		std::cout << "ERROR: " << e.what() << std::endl;
		return 1;
	}

	return 0;
}
